/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6796;
import net.minecraft.class_6862;

public final class BiomeSelection {
    private BiomeSelection() {
    }

    public static boolean hasName(BiomeSelectionContext context, String ... names) {
        return Arrays.stream(names).anyMatch(name -> context.getBiomeKey().method_29177().method_12832().contains((CharSequence)name));
    }

    public static boolean hasNamespace(BiomeSelectionContext context, String ... namespace) {
        return Arrays.stream(namespace).anyMatch(name -> context.getBiomeKey().method_29177().method_12836().contains((CharSequence)name));
    }

    @SafeVarargs
    public static boolean isBiome(BiomeSelectionContext context, class_5321<class_1959> ... keys) {
        return Arrays.stream(keys).anyMatch(key -> context.getBiomeKey().equals(key));
    }

    public static boolean haveCategories(BiomeSelectionContext context, class_6862<class_1959> ... tagKeys) {
        return Arrays.stream(tagKeys).anyMatch(arg_0 -> ((BiomeSelectionContext)context).hasTag(arg_0));
    }

    public static boolean isBiomeAllowed(BiomeSelectionContext context, class_6796 placedFeature, Supplier<Boolean> defaultCondition) {
        return BiomeSelection.isBiomeAllowed(context, placedFeature, class_5458.field_35761) || !BiomeSelection.isBiomeDisallowed(context, placedFeature, class_5458.field_35761) && defaultCondition.get() != false;
    }

    public static <T> boolean isBiomeAllowed(BiomeSelectionContext context, T worldgenObject, class_2378<T> registry) {
        class_2960 registryId = registry.method_10221(worldgenObject);
        String biomeID = context.getBiomeKey().method_29177().toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_ALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> pattern.matcher(biomeID).matches());
    }

    public static <T> boolean isBiomeDisallowed(BiomeSelectionContext context, T worldgenObject, class_2378<T> registry) {
        class_2960 registryId = registry.method_10221(worldgenObject);
        String biomeID = context.getBiomeKey().method_29177().toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_DISALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> pattern.matcher(biomeID).matches());
    }

    public static boolean isBiomeAllowed(BiomeSelectionContext context, class_3195<?> structureFeature, Supplier<Boolean> defaultCondition) {
        return BiomeSelection.isBiomeAllowed(context, structureFeature, class_2378.field_16644) || !BiomeSelection.isBiomeDisallowed(context, structureFeature, class_2378.field_16644) && defaultCondition.get() != false;
    }
}

